require( "quest/m3_gravyboat/convout.lua" );
combine_speech_tables();

function collected_everything()
	return ( game:Get( "bouquets_delivered" ) == 1 ) and
		( game:Get( "got_rings" ) == 1 ) and
		( game:Get( "got_all_butterflies" ) == 1 );
	--return true;
end

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};
flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);

		actor:JumpToNamedPoint("intersection");
		actor:FaceNow(DIR.E);
		scene:SetCameraFollowActor(actor);
		actor:WalkTo("gravy");
		
		scene.CAMERA:JumpToNamedPoint("gravy");
		
		wait_walkto();
		actor:Face(DIR.S);
		scene:SetCameraFollowActor(scene.CAMERA);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		
		if collected_everything() and game:Get("bernie_ship_conversation") == 0 then
			actor:Face(DIR.E);
			run_super_conversation(actor, "conv_ship_bernie_A");
			game:Set("bernie_ship_conversation", 1);
			run_super_conversation(actor, "quip_ship_deliver_time");
		end
		
		game:Set("first_time_cruiseship", 1);
		
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		if collected_everything() then
			convproc("FLO", "quip_board_ship");
		else
			convproc("FLO", "quip_flo_general");
		end
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	
	if collected_everything() then
		run_super_conversation(flo, "quip_ship_exit");
		flo:SetMode(MODE.FOLLOWCLICKS);
	else
		flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		scene:SetCameraFollowActor(scene.FLO);
		flo:WalkTo("to_intersection");
		delay(150);
		goto_scene(flo, "m3_intersection", true);
	end
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_w";
	goto_fn = gotointersection;
}

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		actor:JumpToNamedPoint("intersection");
	end;
};

simon_anim_table = 
{
	"anim/simon/stand",
	"anim/simon/talk",
};

simon_spec = 
{
	name = "SIMON";
	halo = "quest/objects/simon";
	anim = simon_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, simon_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		--actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("simon");
		actor:SetWalkSpeed(simon_speed);
		actor:SetDepthValue( 200 );
		actor:SetScale( 1.0 );
		actor:FaceNow(DIR.W);
	end;
	
	on_arrive = function(flo, simon)
		flo:StartProc(talk_to_simon);
	end;
};

local simon_talk = 0;

function talk_to_simon(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.W);
	if ( game:Get( "talked_to_simon" ) == 0 ) then
		run_super_conversation(flo, "conv_simon_A");	
		game:Set( "talked_to_simon", 1 );
	else
		if simon_talk == 0 then
			if ( game:Get( "bouquets_delivered" ) ~= 1 ) then
				run_super_conversation(flo, "conv_simon_B");
			elseif ( game:Get( "found_bernie" ) ~= 1 ) then
				run_super_conversation(flo, "conv_simon_C");			
			else
				run_super_conversation(flo, "conv_simon_D");
			end
			
			simon_talk = 1;
		else
			run_super_conversation(flo, "conv_simon_AA");
			simon_talk = 0;
		end
	end	
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function bernie_intro(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_news_intro");		
	game:Set( "bernie_intro_done", 1 );
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function talk_to_bernie(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "quip_board_ship");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

bernie_spec = 
{
	name = "BERNIE";
	halo = "quest/objects/bernie";
	gfx = { anim = "anim/bernie/gravyboat" };
	
	command = function(actor)
		prepare_actor_text(actor, bernie_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		--actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("bernie");
		actor:SetWalkSpeed(bernie_speed);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:FaceNow(DIR.W);
	end;
	
	on_arrive = function(flo, bernie)
		flo:StartProc(talk_to_bernie);
	end;
};

cruiseship_spec = 
{
	name = "CRUISESHIP";
	halo = "cruiseship";
	gfx = { image = "ship" };
	
	command = function(actor)
		actor:SetDepthValue(9);
	end;
	
	on_arrive = function(flo, simon)
		flo:StartProc(talk_cruiseship);
	end;
	
	point_at_fn = function(actor, enter)
		if scene.FLO:GetMode() ~= MODE.CUTSCENE and enter then
			actor:LoadImage("ship_highlight");
		else
			actor:LoadImage("ship");
		end
	end
};

function talk_cruiseship(flo)
	flo:SetMode(MODE.CUTSCENE);	
	if ( game:Get( "bouquets_delivered" ) ~= 1 ) then
		run_super_conversation(flo, "quip_ship_A");
		flo:SetMode(MODE.FOLLOWCLICKS);
	elseif ( game:Get( "got_rings" ) ~= 1 ) then
		if ( game:Get( "got_all_butterflies" ) ~= 1 ) then
			run_super_conversation(flo, "quip_ship_B");
			flo:SetMode(MODE.FOLLOWCLICKS);
		else
			run_super_conversation(flo, "quip_ship_C");
			flo:SetMode(MODE.FOLLOWCLICKS);
		end
	else
		if ( game:Get( "got_all_butterflies" ) ~= 1 ) then
			run_super_conversation(flo, "quip_ship_D");			
			flo:SetMode(MODE.FOLLOWCLICKS);
		else
			run_super_conversation(flo, "quip_enter_ship");
			complete_quest("got_rings");
			wait_subscene();
			
			scene:SetFadeTarget { a = 1, r = 0, g = 0, b = 0 };
			scene:SetFadeSpeed(0.05);
			scene:SetMusicVolumeSpeed(0.05);
			wait_fade();

			sfx:SetMusic("audio/music/music_movie_delivery_rings.ogg", true);
			scene:DisplayFlash("flash/deliverycut_scene_ring_butterfly_intro.swf");
			wait_subscene();	
			
			scene:ChainTo("mg_pizza");
		end
	end
end

function spawn_boats()
	spawn_boat("boat1", false, 200, 1, 0.25);
	spawn_boat("boat2", false, 210, 3, 0.5);
	spawn_boat("boat3", true, 205, 2, 0.35);
end

function spawn_boat(_image, _face_right, _height, _depth, _speed)
	return scene:Spawn
	{
		name = string.upper(_image);
		gfx = { image = _image };
		
		command = function(actor)
			local height = _height-actor:GetImageSize().y;
			actor:SetDepthValue(_depth);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			actor:SetWalkSpeed(_speed);
			local background_width = 1200;
			local left_edge = -actor:GetImageSize().x-100;
			local right_edge = background_width+100;
			
			actor:JumpToPoint { x = math.random(0, background_width), y = height };
			
			while true do
				local sail_right = math.random(1,2) == 2;
				local xpos = right_edge;
				if sail_right then
					xpos = left_edge;
				end
				
				if _face_right ~= sail_right then
					actor:SetScaleX(-1);
				else
					actor:SetScaleX(1);
				end
				
				local walkToX = left_edge;
				
				if sail_right then
					walkToX = right_edge;
				end
				
				actor:WalkToXY{ x = walkToX, y = height };
				wait_walkto(actor);
				actor:JumpToPoint { x = xpos, y = height };
			end
		end;
	}
end

ambient_sound_spec = 
{
	name = "AMBIENT_SOUND";
	
	command = function(actor)
		while true do
			delay(math.random(300, 600));
			if math.random(1,2) == 1 then
				sfx:PlaySFX("audio/sfx/gravy_ambient_1");
			else
				sfx:PlaySFX("audio/sfx/gravy_ambient_2");
			end
		end
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_streets3.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		
		local no_fade = game:GetLastScene() == "m3_intersection";
		fade_scene_up(false, no_fade);
		
		if IsCheatMode() then
			-- testing data
			--complete_quest("flowers", false);
			--complete_quest("rings", false);
			--game:Set( "bouquets_delivered", 1);
			--game:Set( "got_rings", 1);
			--game:Set( "butterflies_1", 1);
			--game:Set( "butterflies_2", 1);
		end
		
		spawn_nav_arrow(to_intersection_spec);
		
		scene:SetRoomScale(300, 550, 0.8, 1.0);	--topline, bottomline, topscale, bottomscale
		
		scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		if collected_everything() then
			scene:Spawn(bernie_spec);
		else
			scene:Spawn(simon_spec);
		end
		
		spawn_boats();
		
		spawn_simple_hotspot("end_of_street", 5);
		
		game:SetString("map_position", "m3_gravyboat");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		--{ "objects", 5 },

		{ "midground", 10 },
		{ "stair_rails", 425 },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		cruiseship_spec,
		ambient_sound_spec,
		scene_setup,
		
		flo_spec, -- the main actor
	};
};
